﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace Chapitre_13
{
    class Cube
    {
        VertexPositionNormalTexture[] vertices;
        short[] indices;
        GraphicsDevice graphicsDevice;
        Texture2D texture;
        Vector3 position;
        float widthOver2;

        Effect effect;
        Matrix projection;
        Matrix view;

        ContentManager Content;

        public Cube(GraphicsDevice graphicsDevice, Vector3 position, float width, Matrix projection, Matrix view)
        {
            this.graphicsDevice = graphicsDevice;
            this.position = position;
            this.widthOver2 = width / 2;
            this.projection = projection;
            this.view = view;

            InitializeVertices();
            InitializeIndices();
        }

        public void LoadContent(ContentManager Content, string assetName)
        {
            texture = Content.Load<Texture2D>(assetName);

            effect = Content.Load<Effect>("Greyscale");
            effect.Parameters["Projection"].SetValue(projection);
            effect.Parameters["View"].SetValue(view);
            effect.Parameters["World"].SetValue(Matrix.Identity);
            effect.Parameters["Texture"].SetValue(texture);

            this.Content = Content;
        }

        public void Update(GameTime gameTime)
        {
            //effect.World = Matrix.CreateRotationX(0.3f * (float)gameTime.TotalGameTime.TotalSeconds)
        //* Matrix.CreateRotationY(0.3f * (float)gameTime.TotalGameTime.TotalSeconds)
        //* Matrix.CreateRotationZ(0.3f * (float)gameTime.TotalGameTime.TotalSeconds);
        }

        public void Draw(GameTime gameTime)
        {
            graphicsDevice.VertexDeclaration = new VertexDeclaration(graphicsDevice, VertexPositionNormalTexture.VertexElements);

          //  effect.Parameters["Timer"].SetValue((float)gameTime.TotalGameTime.TotalSeconds);

            effect.CurrentTechnique = effect.Techniques["Default"];

            effect.Begin();
            foreach (EffectPass CurrentPass in effect.CurrentTechnique.Passes)
            {
                CurrentPass.Begin();
                graphicsDevice.DrawUserIndexedPrimitives(PrimitiveType.TriangleList, vertices, 0, vertices.Length, indices, 0, indices.Length / 3);
                CurrentPass.End();
            }
            effect.End();
        }

        private void InitializeVertices()
        {
            vertices = new VertexPositionNormalTexture[24];

            // Front Top left corner
            vertices[0].Position = new Vector3(position.X - widthOver2, position.Y + widthOver2, position.Z + widthOver2);
            vertices[0].TextureCoordinate = new Vector2(0, 0);
            vertices[0].Normal = new Vector3(0, 0, 1);

            // Front Bottom right corner
            vertices[1].Position = new Vector3(position.X + widthOver2, position.Y - widthOver2, position.Z + widthOver2);
            vertices[1].TextureCoordinate = new Vector2(1, 1);
            vertices[1].Normal = new Vector3(0, 0, 1);

            // Front Bottom left corner
            vertices[2].Position = new Vector3(position.X - widthOver2, position.Y - widthOver2, position.Z + widthOver2);
            vertices[2].TextureCoordinate = new Vector2(0, 1);
            vertices[2].Normal = new Vector3(0, 0, 1);

            // Front Top right corner
            vertices[3].Position = new Vector3(position.X + widthOver2, position.Y + widthOver2, position.Z + widthOver2);
            vertices[3].TextureCoordinate = new Vector2(1, 0);
            vertices[3].Normal = new Vector3(0, 0, 1);

            // Back Top left corner
            vertices[4].Position = new Vector3(position.X + widthOver2, position.Y + widthOver2, position.Z - widthOver2);
            vertices[4].TextureCoordinate = new Vector2(0, 0);
            vertices[4].Normal = new Vector3(0, 0, -1);

            // Back Bottom right corner
            vertices[5].Position = new Vector3(position.X - widthOver2, position.Y - widthOver2, position.Z - widthOver2);
            vertices[5].TextureCoordinate = new Vector2(2, 2);
            vertices[5].Normal = new Vector3(0, 0, -1);

            // Back Bottom left corner
            vertices[6].Position = new Vector3(position.X + widthOver2, position.Y - widthOver2, position.Z - widthOver2);
            vertices[6].TextureCoordinate = new Vector2(0, 2);
            vertices[6].Normal = new Vector3(0, 0, -1);

            // Back Top right corner
            vertices[7].Position = new Vector3(position.X - widthOver2, position.Y + widthOver2, position.Z - widthOver2);
            vertices[7].TextureCoordinate = new Vector2(2, 0);
            vertices[7].Normal = new Vector3(0, 0, -1);

            // Left Top left corner
            vertices[8].Position = new Vector3(position.X - widthOver2, position.Y + widthOver2, position.Z - widthOver2);
            vertices[8].TextureCoordinate = new Vector2(0, 0);
            vertices[8].Normal = new Vector3(-1, 0, 0);

            // Left Bottom right corner
            vertices[9].Position = new Vector3(position.X - widthOver2, position.Y - widthOver2, position.Z + widthOver2);
            vertices[9].TextureCoordinate = new Vector2(2, 2);
            vertices[9].Normal = new Vector3(-1, 0, 0);

            // Left Bottom left corner
            vertices[10].Position = new Vector3(position.X - widthOver2, position.Y - widthOver2, position.Z - widthOver2);
            vertices[10].TextureCoordinate = new Vector2(0, 2);
            vertices[10].Normal = new Vector3(-1, 0, 0);

            // Left Top right corner
            vertices[11].Position = new Vector3(position.X - widthOver2, position.Y + widthOver2, position.Z + widthOver2);
            vertices[11].TextureCoordinate = new Vector2(2, 0);
            vertices[11].Normal = new Vector3(-1, 0, 0);

            // Right Top left corner
            vertices[12].Position = new Vector3(position.X + widthOver2, position.Y + widthOver2, position.Z + widthOver2);
            vertices[12].TextureCoordinate = new Vector2(0, 0);
            vertices[12].Normal = new Vector3(1, 0, 0);

            // Right Bottom right corner
            vertices[13].Position = new Vector3(position.X + widthOver2, position.Y - widthOver2, position.Z - widthOver2);
            vertices[13].TextureCoordinate = new Vector2(1, 1);
            vertices[13].Normal = new Vector3(1, 0, 0);

            // Right Bottom left corner
            vertices[14].Position = new Vector3(position.X + widthOver2, position.Y - widthOver2, position.Z + widthOver2);
            vertices[14].TextureCoordinate = new Vector2(0, 1);
            vertices[14].Normal = new Vector3(1, 0, 0);

            // Right Top right corner
            vertices[15].Position = new Vector3(position.X + widthOver2, position.Y + widthOver2, position.Z - widthOver2);
            vertices[15].TextureCoordinate = new Vector2(1, 0);
            vertices[15].Normal = new Vector3(1, 0, 0);

            // Bottom Top left corner
            vertices[16].Position = new Vector3(position.X - widthOver2, position.Y - widthOver2, position.Z + widthOver2);
            vertices[16].Normal = new Vector3(0, -1, 0);

            // Bottom Bottom right corner
            vertices[17].Position = new Vector3(position.X + widthOver2, position.Y - widthOver2, position.Z - widthOver2);
            vertices[17].Normal = new Vector3(0, -1, 0);

            // Bottom Bottom left corner
            vertices[18].Position = new Vector3(position.X - widthOver2, position.Y - widthOver2, position.Z - widthOver2);
            vertices[18].Normal = new Vector3(0, -1, 0);

            // Bottom Top right corner
            vertices[19].Position = new Vector3(position.X + widthOver2, position.Y - widthOver2, position.Z + widthOver2);
            vertices[19].Normal = new Vector3(0, -1, 0);

            // Top Top left corner
            vertices[20].Position = new Vector3(position.X - widthOver2, position.Y + widthOver2, position.Z - widthOver2);
            vertices[20].Normal = new Vector3(0, 1, 0);

            // Top Bottom right corner
            vertices[21].Position = new Vector3(position.X + widthOver2, position.Y + widthOver2, position.Z + widthOver2);
            vertices[21].Normal = new Vector3(0, 1, 0);

            // Top Bottom left corner
            vertices[22].Position = new Vector3(position.X - widthOver2, position.Y + widthOver2, position.Z + widthOver2);
            vertices[22].Normal = new Vector3(0, 1, 0);

            // Top Top right corner
            vertices[23].Position = new Vector3(position.X + widthOver2, position.Y + widthOver2, position.Z - widthOver2);
            vertices[23].Normal = new Vector3(0, 1, 0);
        }

        private void InitializeIndices()
        {
            indices = new short[36];

            indices[0] = 0;
            indices[1] = 1;
            indices[2] = 2;
            indices[3] = 0;
            indices[4] = 3;
            indices[5] = 1;

            indices[6] = 4;
            indices[7] = 5;
            indices[8] = 6;
            indices[9] = 4;
            indices[10] = 7;
            indices[11] = 5;

            indices[12] = 8;
            indices[13] = 9;
            indices[14] = 10;
            indices[15] = 8;
            indices[16] = 11;
            indices[17] = 9;

            indices[18] = 12;
            indices[19] = 13;
            indices[20] = 14;
            indices[21] = 12;
            indices[22] = 15;
            indices[23] = 13;

            indices[24] = 16;
            indices[25] = 17;
            indices[26] = 18;
            indices[27] = 16;
            indices[28] = 19;
            indices[29] = 17;

            indices[30] = 20;
            indices[31] = 21;
            indices[32] = 22;
            indices[33] = 20;
            indices[34] = 23;
            indices[35] = 21;
        }
    }
}
